/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.ws.VWWSWorkflow;
import filenet.vw.toolkit.utils.ws.base.VWUDDIPublishStatus;
import filenet.vw.toolkit.utils.ws.base.wsrr.IVWWSRREventListener;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRREvent;
import filenet.vw.toolkit.utils.ws.base.wsrr.VWWSRRRegistryItem;
import filenet.vw.toolkit.utils.ws.wsrr.VWWSRRRegistryManager;
import filenet.ws.api.wsrr.WSWSRRWsdlDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class VWWSRRProcessMonitorDialog
extends VWModalDialog
implements ActionListener,
IVWWSRREventListener,
Runnable {
    public static final int STATUS_INTERRUPTED = 3;
    public static final int STATUS_COMPLETED = 4;
    public static final int STATUS_FAILED = 5;
    public static final int STATUS_CANCELED = 6;
    public static final int OPTION_PUBLISH_WORKFLOW = 1;
    public static final int OPTION_DELETE_WSDL = 2;
    private static final String ACTION_CLOSE = VWResource.s_close;
    private static final String ACTION_INTERRUPT = VWResource.s_interrupt;
    private static final String ACTION_SHOW_DETAILS = VWResource.s_details;
    private static final String ACTION_HIDE_DETAILS = VWResource.s_hideDetails;
    private static final String ACTION_HELP = VWResource.s_help;
    private Frame m_parentFrame = null;
    private VWWSRRRegistryManager m_wsrrRegistryManager = null;
    private VWWSRRRegistryItem m_registryItem = null;
    private WSWSRRWsdlDocument m_documentItem = null;
    private VWWSWorkflow[] m_workflows = null;
    private int m_processOption;
    private JPanel m_progressPanel = null;
    private JPanel m_detailsPanel = null;
    private JPanel m_buttonPanel = null;
    private JLabel m_progressStatusLeft = new JLabel();
    private JLabel m_progressStatusRight = new JLabel();
    private JLabel m_progressDetailLeft = new JLabel();
    private JLabel m_progressDetailRight = new JLabel();
    private JProgressBar m_progressBar = null;
    private JLabel m_progressStatusLabel = null;
    private Vector m_detailsMessages = new Vector();
    private JButton m_closeStopButton = new JButton(VWResource.s_stop);
    private JButton m_detailsButton = new JButton();
    private JButton m_helpButton = new JButton(ACTION_HELP);
    private int m_status;
    private boolean m_bStopProcessing = false;
    private int m_errorCount = 0;
    private int m_successCount = 0;
    private int m_totalItems = 0;
    private int m_numItemlProcessed = 0;
    private int m_processDuration = 0;
    private int m_referenceCount = 0;
    private String m_title = null;
    private Dimension m_progressViewDim = VWStringUtils.stringToDimension("495, 175");
    private Dimension m_progressDetailViewDim = VWStringUtils.stringToDimension("495, 335");

    public VWWSRRProcessMonitorDialog(Frame parent, VWWSRRRegistryManager wsrrRegistryManager, VWWSRRRegistryItem registryItem, VWWSWorkflow[] workflows, int option, String title) {
        super(parent);
        this.m_parent = parent;
        this.m_processOption = option;
        this.m_wsrrRegistryManager = wsrrRegistryManager;
        this.m_registryItem = registryItem;
        this.m_workflows = workflows;
        this.m_title = title;
        this.init();
        VWAccessibilityHelper.setAccessibility(this, parent, this.getTitle(), this.getTitle());
        this.startProcess();
    }

    public VWWSRRProcessMonitorDialog(Frame parent, VWWSRRRegistryManager wsrrRegistryManager, VWWSRRRegistryItem registryItem, WSWSRRWsdlDocument documentItem, int option, String title) {
        super(parent);
        this.m_parent = parent;
        this.m_processOption = option;
        this.m_wsrrRegistryManager = wsrrRegistryManager;
        this.m_registryItem = registryItem;
        this.m_documentItem = documentItem;
        this.m_title = title;
        this.init();
        this.startProcess();
    }

    private void init() {
        try {
            if (this.m_progressViewDim == null) {
                this.m_progressViewDim = new Dimension(450, 155);
            }
            this.setSize(this.m_progressViewDim.width, this.m_progressViewDim.height);
            this.setTitle(this.m_title);
            switch (this.m_processOption) {
                case 1: {
                    this.m_closeStopButton.setText(VWResource.s_stop);
                    this.m_closeStopButton.setActionCommand(ACTION_INTERRUPT);
                    this.m_closeStopButton.setEnabled(true);
                    this.m_totalItems = this.m_workflows.length;
                    this.m_processDuration = this.m_totalItems + 2;
                    break;
                }
                case 2: {
                    this.m_closeStopButton.setText(ACTION_CLOSE);
                    this.m_closeStopButton.setActionCommand(ACTION_CLOSE);
                    this.m_closeStopButton.setEnabled(false);
                    this.m_totalItems = 1;
                    this.m_processDuration = 4;
                    break;
                }
            }
            this.displayProgressInfoLayout(false);
            this.setVisible(false);
            this.m_closeStopButton.addActionListener(this);
            this.m_detailsButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.m_helpButton.setActionCommand(ACTION_HELP);
            VWAccessibilityHelper.setAccessibility(this.m_closeStopButton, null, this.m_closeStopButton.getText(), this.m_closeStopButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_detailsButton, null, this.m_detailsButton.getText(), this.m_detailsButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, null, this.m_helpButton.getText(), this.m_helpButton.getText());
            this.setLocationRelativeTo(this.m_parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void startProcess() {
        this.m_wsrrRegistryManager.addPublishListener(this);
        Thread publishThread = new Thread(this);
        publishThread.start();
    }

    public void run() {
        try {
            switch (this.m_processOption) {
                case 1: {
                    this.m_wsrrRegistryManager.publishService(this.m_parentFrame, this.m_registryItem, this.m_workflows);
                    break;
                }
                case 2: {
                    this.m_status = this.m_wsrrRegistryManager.deleteWSDL(this.m_parentFrame, this.m_registryItem, this.m_documentItem);
                }
            }
        }
        catch (InterruptedException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public synchronized void WSRRBusinessChanged(VWWSRREvent evt) {
        int eventType = evt.getEventType();
        int status = evt.getStatus();
        Object eventObj = evt.getSource();
        String message = evt.getMessage();
        this.m_referenceCount = evt.getReferenceCount() + 1;
        JLabel detailsLabel = null;
        String progress = null;
        switch (eventType) {
            case 1: {
                this.m_progressDetailRight.setText(VWResource.s_processMofN.toString(Integer.toString(this.m_numItemlProcessed), Integer.toString(this.m_totalItems)));
                if (eventObj != null) {
                    String name = (String)eventObj;
                    if (this.m_processOption == 2) {
                        this.m_progressDetailLeft.setText(VWResource.s_deletingCurrentItem.toString(name));
                    } else {
                        this.m_progressDetailLeft.setText(VWResource.s_publishingCurrentItem.toString(name));
                    }
                }
                this.m_progressDetailLeft.getAccessibleContext().setAccessibleDescription(this.m_progressDetailLeft.getText());
                this.m_progressDetailLeft.getAccessibleContext().setAccessibleName(this.m_progressDetailLeft.getText());
                this.m_progressDetailRight.getAccessibleContext().setAccessibleDescription(this.m_progressDetailRight.getText());
                this.m_progressDetailRight.getAccessibleContext().setAccessibleName(this.m_progressDetailRight.getText());
                break;
            }
            case 2: {
                this.m_progressBar.setValue(this.m_referenceCount);
                progress = new String() + this.m_referenceCount * 100 / this.m_totalItems + "%";
                VWAccessibilityHelper.setAccessibility(this.m_progressBar, null, progress, progress);
                if (message == null || message.length() <= 0) break;
                String name = (String)eventObj;
                VWUDDIPublishStatus pst = new VWUDDIPublishStatus(name, status, message);
                detailsLabel = pst.toWSRRJLabel(this.m_processOption);
                this.m_detailsMessages.add(detailsLabel);
                if (this.m_detailsPanel == null) break;
                this.m_detailsPanel.add(detailsLabel);
                break;
            }
            case 3: {
                String name = (String)eventObj;
                ++this.m_numItemlProcessed;
                if (status == 2) {
                    ++this.m_errorCount;
                } else if (status == 1) {
                    ++this.m_successCount;
                }
                VWUDDIPublishStatus pst = new VWUDDIPublishStatus(name, status, message);
                detailsLabel = pst.toWSRRJLabel(this.m_processOption);
                this.m_detailsMessages.add(detailsLabel);
                if (this.m_detailsPanel != null) {
                    this.m_detailsPanel.add(detailsLabel);
                }
                this.m_progressBar.setValue(this.m_referenceCount);
                progress = new String() + this.m_referenceCount * 100 / this.m_totalItems + "%";
                VWAccessibilityHelper.setAccessibility(this.m_progressBar, null, progress, progress);
                this.m_progressDetailRight.setText(VWResource.s_processMofN.toString(Integer.toString(this.m_numItemlProcessed), Integer.toString(this.m_totalItems)));
                if (name == null || name.length() <= 0) break;
                if (this.m_processOption == 2) {
                    this.m_progressDetailLeft.setText(VWResource.s_deletingCurrentItem.toString(name));
                } else {
                    this.m_progressDetailLeft.setText(VWResource.s_publishingCurrentItem.toString(name));
                }
                this.m_progressDetailRight.getAccessibleContext().setAccessibleDescription(this.m_progressDetailRight.getText());
                this.m_progressDetailRight.getAccessibleContext().setAccessibleName(this.m_progressDetailRight.getText());
                this.m_progressDetailLeft.getAccessibleContext().setAccessibleDescription(this.m_progressDetailLeft.getText());
                this.m_progressDetailLeft.getAccessibleContext().setAccessibleName(this.m_progressDetailLeft.getText());
                break;
            }
            case 4: {
                VWUDDIPublishStatus pstSummary;
                this.m_progressStatusRight.setText(VWResource.s_numOfErrors.toString(Integer.toString(this.m_errorCount)));
                this.m_progressDetailLeft.setText(VWResource.s_totalProcessed);
                this.m_closeStopButton.setText(ACTION_CLOSE);
                this.m_closeStopButton.setActionCommand(ACTION_CLOSE);
                this.m_closeStopButton.setEnabled(true);
                VWAccessibilityHelper.setAccessibility(this.m_progressStatusRight, null, this.m_progressStatusRight.getText(), this.m_progressStatusRight.getText());
                VWAccessibilityHelper.setAccessibility(this.m_progressDetailLeft, null, this.m_progressDetailLeft.getText(), this.m_progressDetailLeft.getText());
                VWAccessibilityHelper.setAccessibility(this.m_closeStopButton, null, this.m_closeStopButton.getText(), this.m_closeStopButton.getText());
                String msg = VWResource.s_publishSummary.toString(Integer.toString(this.m_numItemlProcessed), Integer.toString(this.m_successCount), Integer.toString(this.m_errorCount));
                this.m_status = status;
                if (status == 4) {
                    this.m_progressStatusLeft.setText(VWResource.s_processCompleted);
                    pstSummary = new VWUDDIPublishStatus("", 4, msg);
                    VWAccessibilityHelper.setAccessibility(this.m_progressStatusLeft, null, this.m_progressStatusLeft.getText(), this.m_progressStatusLeft.getText());
                } else if (status == 3) {
                    this.m_progressStatusLeft.setText(VWResource.s_processInterrupted);
                    pstSummary = new VWUDDIPublishStatus("", 3, msg);
                    VWAccessibilityHelper.setAccessibility(this.m_progressStatusLeft, null, this.m_progressStatusLeft.getText(), this.m_progressStatusLeft.getText());
                } else if (status == 5) {
                    this.m_progressStatusLeft.setText(VWResource.s_processFailed);
                    pstSummary = new VWUDDIPublishStatus("", 5, msg);
                    VWAccessibilityHelper.setAccessibility(this.m_progressStatusLeft, null, this.m_progressStatusLeft.getText(), this.m_progressStatusLeft.getText());
                } else {
                    pstSummary = new VWUDDIPublishStatus("", 0, msg);
                }
                detailsLabel = pstSummary.toWSRRJLabel(this.m_processOption);
                this.m_detailsMessages.add(detailsLabel);
                if (this.m_detailsPanel == null) break;
                this.m_detailsPanel.add(detailsLabel);
            }
        }
        this.validate();
        this.repaint();
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        if (VWStringUtils.compare(actionCMD, ACTION_CLOSE) == 0) {
            this.m_wsrrRegistryManager.removePublishListener(this);
            this.setVisible(false);
        } else if (VWStringUtils.compare(actionCMD, ACTION_SHOW_DETAILS) == 0) {
            this.displayDetailInfoLayout();
            this.m_detailsButton.requestFocus();
        } else if (VWStringUtils.compare(actionCMD, ACTION_HIDE_DETAILS) == 0) {
            this.displayProgressInfoLayout(true);
            this.m_detailsButton.requestFocus();
        } else if (VWStringUtils.compare(actionCMD, ACTION_INTERRUPT) == 0) {
            this.m_bStopProcessing = true;
            this.m_closeStopButton.setText(ACTION_CLOSE);
            this.m_closeStopButton.setActionCommand(ACTION_CLOSE);
            this.m_wsrrRegistryManager.setPublishCanceled(true);
            VWAccessibilityHelper.setAccessibility(this.m_closeStopButton, null, this.m_closeStopButton.getText(), this.m_closeStopButton.getText());
        } else if (VWStringUtils.compare(actionCMD, ACTION_HELP) == 0) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc095.htm");
        }
    }

    public void releaseResources() {
        if (this.m_closeStopButton != null) {
            this.m_closeStopButton.removeActionListener(this);
            this.m_closeStopButton.removeAll();
            this.m_closeStopButton = null;
        }
        if (this.m_detailsButton != null) {
            this.m_detailsButton.removeActionListener(this);
            this.m_detailsButton.removeAll();
            this.m_detailsButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        if (this.m_detailsMessages != null) {
            this.m_detailsMessages.clear();
        }
        this.m_wsrrRegistryManager.removePublishListener(this);
        this.removeAll();
    }

    private JPanel createProgressPanel() {
        this.m_progressPanel = new JPanel();
        this.m_progressPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(5, 5, 5, 5);
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 0;
        ImageIcon infoIcon = VWImageLoader.createImageIcon("info.gif");
        JLabel iconLabel = new JLabel(infoIcon);
        this.m_progressPanel.add((Component)iconLabel, gbCons);
        VWAccessibilityHelper.setAccessibility(iconLabel, this.m_progressPanel, VWResource.s_information, VWResource.s_information);
        gbCons.gridheight = 1;
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        this.m_progressStatusLeft.setText(VWResource.s_processInProgress);
        this.m_progressPanel.add((Component)this.m_progressStatusLeft, gbCons);
        VWAccessibilityHelper.setAccessibility(this.m_progressStatusLeft, this.m_progressPanel, VWResource.s_processInProgress, VWResource.s_processInProgress);
        ++gbCons.gridx;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        this.m_progressStatusRight.setText(VWResource.s_numOfErrors.toString(Integer.toString(this.m_errorCount)));
        this.m_progressPanel.add((Component)this.m_progressStatusRight, gbCons);
        VWAccessibilityHelper.setAccessibility(this.m_progressStatusRight, this.m_progressPanel, VWResource.s_errorCount, VWResource.s_errorCount);
        gbCons.gridx = 1;
        ++gbCons.gridy;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        this.m_progressPanel.add((Component)this.m_progressDetailLeft, gbCons);
        VWAccessibilityHelper.setAccessibility(this.m_progressDetailLeft, this.m_progressPanel, this.m_progressDetailLeft.getText(), this.m_progressDetailLeft.getText());
        ++gbCons.gridx;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        this.m_progressDetailRight.setText(VWResource.s_processMofN.toString(Integer.toString(this.m_numItemlProcessed, this.m_totalItems)));
        this.m_progressPanel.add((Component)this.m_progressDetailRight, gbCons);
        VWAccessibilityHelper.setAccessibility(this.m_progressDetailRight, this.m_progressPanel, this.m_progressDetailRight.getText(), this.m_progressDetailRight.getText());
        this.m_progressBar = new JProgressBar(0, this.m_processDuration);
        this.m_progressStatusLabel = new JLabel();
        this.m_progressBar.setValue(0);
        this.m_progressBar.setStringPainted(true);
        gbCons.gridx = 1;
        ++gbCons.gridy;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.gridwidth = 0;
        this.m_progressPanel.add((Component)this.m_progressBar, gbCons);
        String progress = "0%";
        VWAccessibilityHelper.setAccessibility(this.m_progressBar, this.m_progressPanel, progress, progress);
        return this.m_progressPanel;
    }

    private JPanel createDetailPanel() {
        this.m_detailsPanel = new JPanel();
        this.m_detailsPanel.setLayout(new BoxLayout(this.m_detailsPanel, 3));
        if (this.m_detailsMessages != null) {
            Object obj = null;
            for (int i = 0; i < this.m_detailsMessages.size(); ++i) {
                obj = this.m_detailsMessages.get(i);
                if (obj == null || !(obj instanceof JLabel)) continue;
                this.m_detailsPanel.add((Component)obj);
            }
        }
        return this.m_detailsPanel;
    }

    private JPanel createButtonPanel() {
        this.m_buttonPanel = new JPanel();
        try {
            this.m_buttonPanel.add(this.m_closeStopButton);
            this.m_buttonPanel.add(this.m_detailsButton);
            this.m_buttonPanel.add(this.m_helpButton);
            VWAccessibilityHelper.setAccessibility(this.m_closeStopButton, this.m_buttonPanel, this.m_closeStopButton.getText(), this.m_closeStopButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_detailsButton, this.m_buttonPanel, this.m_detailsButton.getText(), this.m_detailsButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this.m_buttonPanel, this.m_helpButton.getText(), this.m_helpButton.getText());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_buttonPanel;
    }

    private synchronized void displayProgressInfoLayout(boolean bResize) {
        if (bResize) {
            if (this.m_progressViewDim == null) {
                this.m_progressViewDim = new Dimension(450, 155);
            }
            this.setSize(this.m_progressViewDim.width, this.m_progressViewDim.height);
            this.getContentPane().removeAll();
        }
        if (this.m_progressPanel == null) {
            this.createProgressPanel();
        }
        if (this.m_buttonPanel == null) {
            this.createButtonPanel();
        }
        this.m_detailsButton.setText(ACTION_SHOW_DETAILS);
        this.m_detailsButton.setActionCommand(ACTION_SHOW_DETAILS);
        VWAccessibilityHelper.setAccessibility(this.m_detailsButton, null, this.m_detailsButton.getText(), this.m_detailsButton.getText());
        JPanel subPanel = new JPanel(new BorderLayout(6, 6));
        subPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        subPanel.add((Component)this.m_progressPanel, "First");
        subPanel.add((Component)this.m_buttonPanel, "Last");
        VWAccessibilityHelper.setAccessibility(this.m_progressPanel, subPanel, null, null);
        VWAccessibilityHelper.setAccessibility(this.m_buttonPanel, subPanel, null, null);
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        this.getContentPane().add((Component)subPanel, "Center");
        VWAccessibilityHelper.setAccessibility(subPanel, this, null, null);
        if (bResize) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    private synchronized void displayDetailInfoLayout() {
        this.m_progressViewDim = this.getSize();
        if (this.m_progressDetailViewDim == null) {
            this.m_progressDetailViewDim = new Dimension(450, 350);
        }
        this.setSize(this.m_progressDetailViewDim.width, this.m_progressDetailViewDim.height);
        this.getContentPane().removeAll();
        if (this.m_progressPanel == null) {
            this.createProgressPanel();
        }
        if (this.m_detailsPanel == null) {
            this.createDetailPanel();
        }
        if (this.m_buttonPanel == null) {
            this.createButtonPanel();
        }
        this.m_detailsButton.setText(ACTION_HIDE_DETAILS);
        this.m_detailsButton.setActionCommand(ACTION_HIDE_DETAILS);
        VWAccessibilityHelper.setAccessibility(this.m_detailsButton, null, this.m_detailsButton.getText(), this.m_detailsButton.getText());
        JPanel subPanel = new JPanel(new BorderLayout(6, 6));
        subPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        subPanel.add((Component)this.m_progressPanel, "First");
        subPanel.add((Component)new JScrollPane(this.m_detailsPanel), "Center");
        subPanel.add((Component)this.m_buttonPanel, "Last");
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        this.getContentPane().add((Component)subPanel, "Center");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    protected class PublishStatusListCellRenderer
    extends DefaultListCellRenderer {
        private final ImageIcon ICON_SUCCEEDED = VWImageLoader.createImageIcon("check_16.gif");
        private final ImageIcon ICON_ERROR = VWImageLoader.createImageIcon("error_16.gif");
        private final ImageIcon ICON_BLANK = VWImageLoader.createImageIcon("blank.gif");

        protected PublishStatusListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof VWUDDIPublishStatus) {
                VWUDDIPublishStatus pst = (VWUDDIPublishStatus)value;
                String id = pst.getId();
                String message = pst.getMessage();
                switch (pst.getStatus()) {
                    case 1: {
                        if (VWWSRRProcessMonitorDialog.this.m_processOption == 2) {
                            this.setText(VWResource.s_businessArgDeleted.toString(id));
                        } else {
                            this.setText(VWResource.s_publishSucceeded.toString(id));
                        }
                        this.setIcon(this.ICON_SUCCEEDED);
                        break;
                    }
                    case 2: {
                        if (id == null || id.length() <= 0) {
                            this.setText(VWResource.s_failedToPublishWorkflow1.toString(message));
                        } else {
                            this.setText(VWResource.s_failedToPublishWorkflow2.toString(id, message));
                        }
                        this.setIcon(this.ICON_ERROR);
                        break;
                    }
                    case 3: {
                        this.setText(VWResource.s_processInterruptedArg.toString(message));
                        break;
                    }
                    case 4: {
                        this.setText(VWResource.s_processCompletedArg.toString(message));
                        break;
                    }
                    case 6: {
                        this.setText(VWResource.s_publishCanceled);
                        break;
                    }
                    case 5: {
                        this.setText(VWResource.s_publishFailedArg.toString(message));
                        break;
                    }
                    default: {
                        this.setText("\"" + id + "\": " + message);
                        this.setIcon(this.ICON_BLANK);
                    }
                }
            }
            VWAccessibilityHelper.setAccessibility(this, null, this.getText(), this.getText());
            return this;
        }
    }
}

